// level.c

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "main.h"
#include "level.h"
#include "score.h"
#include "random.h"
#include "grays.h"
#include "gameticks.h"
#include "players.h"
#include "graymonitor.h"
#include "opponent.h"
#include "gworld.h"
#include "graphics.h"
#include "midi.h"
#include "control.h"
#include "tweak.h"
#include "soundfx.h"
#include "next.h"
#include "wdef.h"
#include "hiscore.h"
#include "victory.h"
#include "blitter.h"
#include "zap.h"
#include "keyselect.h"
#include "tutorial.h"
#include "pause.h"
#include "register.h"
#include "stringtools.h"
#include "keyboard.h"

Rect stageWindowZRect, stageWindowRect;
Character character[2];
int level, players, credits, difficulty[2] = {kHardLevel, kHardLevel};
int difficultyTicks, backdropTicks, backdropFrame;

#define kNumSplats 16
#define kIdleSplat -2
#define kFallingSplat -1
#define kTitleItems 7
#define kIncrementPerFrame 2
#define kSplatType 4

#define min(x,y) (((x)<(y))?(x):(y))
#define max(x,y) (((x)>(y))?(x):(y))

static GWorldPtr gameStart, gameStartDrawWorld;

const int startSkip = 1;
static int startMenuTime = 0;
static int splatState[kNumSplats], splatColor[kNumSplats], splatSide[kNumSplats];
static Rect splatBlob[kNumSplats];
static int glowUpdate = 0, titleGlow[kTitleItems] = {24, 24, 24, 24, 24, 24, 24};
static Rect titleRect[kTitleItems] = {
		{ 155, 203, 207, 426 }, // tutorial
		{ 225, 179, 281, 451 }, // 1p
		{ 297, 182, 352, 454 }, // 2p
		{ 358, 183, 428, 458 }, // solitaire
		{ 429, 280, 478, 390 }, // high scores
		{ 433, 390, 477, 446 }, // quit
		{ 430, 187, 479, 280 }, // controls
		                };

void GameStartMenu( void )
{
	Rect backdropPortZRect = {0, 0, 480, 640};
	Rect drawRect[2], chunkRect;
	int blob, count, oldGlow, splat, chunkType, selected = -1;
	int skip = 1;
	Point mouse;
	SkittlesFontPtr smallFont = GetFont( picFont );
	Point           dPoint;
	Point           sPoint[4];
	char            registeredString[256];
    char           *scan;
redo:

	if( finished ) return;
	
	if( musicSelection != 13 ) ChooseMusic( 13 );
	
	for( count=0; count<kTitleItems; count++ )
	{
		titleGlow[count] = 24;
	}
	
	for( count=0; count<kNumSplats; count++ )
	{
		splatState[count] = kIdleSplat;
	}
	
	InitGWorld( &gameStart, &backdropPortZRect, 16 );	
	DrawPictInGWorld( gameStart, picGameStart );

	// draw user name with a cool blue halo
	if( IsRegistered() )
	{
		sprintf( registeredString, "Registered to %s", registeredName );
	}
	else
	{
		sprintf( registeredString, "U N R E G I S T E R E D" );
	}
	
	dPoint.v = 131;
	dPoint.h = 320 - (GetTextWidth( smallFont, registeredString ) / 2);
	sPoint[0].v = dPoint.v + 1;	sPoint[0].h = dPoint.h + 1;
	sPoint[1].v = dPoint.v - 1;	sPoint[1].h = dPoint.h - 1;
	sPoint[2].v = dPoint.v - 1;	sPoint[2].h = dPoint.h + 1;
	sPoint[3].v = dPoint.v + 1;	sPoint[3].h = dPoint.h - 1;
 
	PrepareForGDrawing( gameStart );
	for( scan = registeredString; *scan; scan++ )
	{		
		BlitCharacter( smallFont, *scan, &sPoint[0], 0, 0, 25, 0 );			
		BlitCharacter( smallFont, *scan, &sPoint[1], 0, 0, 25, 0 );			
		BlitCharacter( smallFont, *scan, &sPoint[2], 0, 0, 25, 0 );			
		BlitCharacter( smallFont, *scan, &sPoint[3], 0, 0, 25, 0 );			
		BlitCharacter( smallFont, *scan, &dPoint, 30, 30, 30, 0 );			
	}
	FinishGDrawing( gameStart );
	// end
	
	InitGWorld( &gameStartDrawWorld, &backdropPortZRect, 16 );	
	PrepareForGDrawing( gameStartDrawWorld );
	
	CopyBits( GetPortBitMapForCopyBits(gameStart), GetPortBitMapForCopyBits(gameStartDrawWorld),
			  &backdropPortZRect, &backdropPortZRect, srcCopy, nil );

	for( count=0; count<kTitleItems; count++ )
	{
		BlitColorOver( GetGWorldPixMap(gameStart), &titleRect[count], 0, 0, 0, titleGlow[count] );
	}
	
	FinishGDrawing( gameStartDrawWorld );
	
	InvisiCursor( );

	SetPort( backdropPort );
	CopyBits( GetPortBitMapForCopyBits(gameStartDrawWorld),
			  GetPortBitMapForCopyBits(backdropPort),
			  &backdropPortZRect, &backdropPortZRect, srcCopy, nil );

	QuickFadeIn( nil );
	PointyCursor();

	startMenuTime = TickCount( );
	while( (selected == -1 || !Button( )) && !finished )
	{
		CheckKeys( false, nil, nil );
	
		startMenuTime += skip;

		// Add a new falling blob 
		if( glowUpdate == 0 ) 
		{
			for( blob=0; blob<kNumSplats; blob++ )
			{
				if( splatState[blob] == kIdleSplat )
				{
					splatSide[blob] = RandomBefore(2);
					splatBlob[blob].top = -24 - RandomBefore(15);
					splatBlob[blob].left = (splatSide[blob] == 0)? RandomBefore( 110 ): 640 - kBlobHorizSize - RandomBefore( 110 );
					splatBlob[blob].bottom = splatBlob[blob].top + kBlobVertSize;
					splatBlob[blob].right = splatBlob[blob].left + kBlobHorizSize;
					splatColor[blob] = ((startMenuTime >> 2) % kBlobTypes) + 1;
					splatState[blob] = kFallingSplat;
					
					break;
				}
			}
		}
	
		// Erase and redraw falling blobs and chunks

		PrepareForGDrawing( gameStartDrawWorld );
	
		// is this a hack? maybe. but it works!
		drawRect[0].top    = drawRect[1].top    = 
		drawRect[0].left   = drawRect[1].left   = 9999;
		drawRect[0].bottom = drawRect[1].bottom =
		drawRect[0].right  = drawRect[1].right  = -9999;
	
		// Erase falling blobs
		for( blob=0; blob<kNumSplats; blob++ )
		{
			if( splatState[blob] == kFallingSplat )
			{
				PaintRect( &splatBlob[blob] );
				UnionRect( &drawRect[splatSide[blob]], &splatBlob[blob], &drawRect[splatSide[blob]] );

				OffsetRect( &splatBlob[blob], 0, startSkip * (6 + (splatBlob[blob].bottom / 20)) );
			}
			else if( splatState[blob] >= kIncrementPerFrame )
			{
				for( splat=-3; splat<=3; splat++ )
				{
					if( splat )
					{
						chunkRect = splatBlob[blob];
						GetZapStyle( 0, &chunkRect, &splatColor[blob], &chunkType, splat, splatState[blob]-kIncrementPerFrame, kSplatType );
						PaintRect( &chunkRect );
						UnionRect( &drawRect[splatSide[blob]], &chunkRect, &drawRect[splatSide[blob]] );
					}
				}
				
				PaintRect( &splatBlob[blob] );
				UnionRect( &drawRect[splatSide[blob]], &splatBlob[blob], &drawRect[splatSide[blob]] );
			}
		}
	
		// Redraw falling blobs
		for( blob=0; blob<kNumSplats; blob++ )
		{
			if( splatState[blob] == kFallingSplat )
			{
				if( splatBlob[blob].bottom >= 480 ) 
				{
					splatBlob[blob].top = 480 - kBlobVertSize;
					splatBlob[blob].bottom = 480;
					splatState[blob] = 1;
				}
				else
				{
					DrawSprite( &splatBlob[blob], splatColor[blob], kNoSuction );
					UnionRect( &drawRect[splatSide[blob]], &splatBlob[blob], &drawRect[splatSide[blob]] );
				}
			}
			
			if( splatState[blob] >= 0 && splatState[blob] <= kZapFrames )
			{
				if( splatState[blob] <= (kZapFrames - kIncrementPerFrame) ) 
				{
					for( splat=-3; splat<=3; splat++ )
					{
						if( splat )
						{
							chunkRect = splatBlob[blob];
							GetZapStyle( 0, &chunkRect, &splatColor[blob], &chunkType, splat, splatState[blob], kSplatType );
							DrawSprite( &chunkRect, splatColor[blob], chunkType );
							UnionRect( &drawRect[splatSide[blob]], &chunkRect, &drawRect[splatSide[blob]] );
						}
					}
					
					DrawSprite( &splatBlob[blob], splatColor[blob], chunkType );
					UnionRect( &drawRect[splatSide[blob]], &splatBlob[blob], &drawRect[splatSide[blob]] );
				}
				
				splatState[blob] += kIncrementPerFrame;
				if( splatState[blob] > kZapFrames ) splatState[blob] = kIdleSplat;
			}
		}
		
		FinishGDrawing( gameStartDrawWorld );		
		
		// Find mouse coords
		
		selected = -1;
		SetPort( backdropPort );
		GetMouse( &mouse );
	
		for( count=0; count<kTitleItems; count++ )
		{
			if( PtInRect( mouse, &titleRect[count] ) )
			{
				selected = count;
				break;
			}
		}

		// update glows -- more time consuming so only do one of the four per frame
		// do 5, 6, and 7  all at once because they're small

		do
		{
			oldGlow = titleGlow[glowUpdate];
			
			if( selected == glowUpdate )
			{
				titleGlow[glowUpdate] -= (4 * startSkip);
				if( titleGlow[glowUpdate] < 0 ) titleGlow[glowUpdate] = 0;
			}
			else 
			{
				titleGlow[glowUpdate] += (4 * startSkip);
				if( titleGlow[glowUpdate] > 24 ) titleGlow[glowUpdate] = 24;
			}
			
			if( titleGlow[glowUpdate] != oldGlow )
			{
				PrepareForGDrawing( gameStartDrawWorld );		
				BlitColorOver( GetGWorldPixMap(gameStart), &titleRect[glowUpdate], 0, 0, 0, titleGlow[glowUpdate] );
				FinishGDrawing( gameStartDrawWorld );		

				CopyBits( GetPortBitMapForCopyBits(gameStartDrawWorld), 
				 		  GetPortBitMapForCopyBits(backdropPort),
			  			  &titleRect[glowUpdate], &titleRect[glowUpdate], 
			  			  srcCopy, nil );
			}

			if( ++glowUpdate >= kTitleItems ) glowUpdate = 0;
		}
		while( glowUpdate >= 6 );

	
		CopyBits( GetPortBitMapForCopyBits(gameStartDrawWorld), 
		 		  GetPortBitMapForCopyBits(backdropPort),
				  &drawRect[0], &drawRect[0],
				  srcCopy, nil );

		CopyBits( GetPortBitMapForCopyBits(gameStartDrawWorld),
		 		  GetPortBitMapForCopyBits(backdropPort),
				  &drawRect[1], &drawRect[1],
				  srcCopy, nil );

		if( startMenuTime <= TickCount( ) )
		{
			startMenuTime = TickCount( );
			skip = 2;
		}
		else
		{
			skip = 1;
			while( startMenuTime > TickCount( ) ) { MPYield();  }
		}
	}

	if( finished ) 
	{
		selected = 5; // quit
	}
	
	switch( selected )
	{
		case 0: 
		case 1: 
		case 2:
		case 3:
			PlayMono( kChime ); 
			break;
	}

	InvisiCursor();
			
	FlushEvents( everyEvent, 0L );
	DisposeGWorld( gameStart );
	DisposeGWorld( gameStartDrawWorld );

	QuickFadeOut( nil );

	switch( selected )
	{
		case 0: 
			InitGame( kAutoControl, kNobodyControl );
			level = kTutorialLevel;
			BeginRound( true );
			InitTutorial( );
			QuickFadeIn( nil );
			break;				

		case 1:
		case 2:
		case 3:
			{
				int player2[] = { 0, kAIControl, kPlayerControl, kNobodyControl };
				
				InitGame( kPlayerControl, player2[selected] );
				BeginRound( true );
				QuickFadeIn( nil );
				break;
			}
		
		case 4: 
			ShowHiscore();
			ShowBestCombo();
			break;
			
		case 5:
			finished = true;
			break;
		
		case 6:
			SetPort( backdropPort );
			ForeColor( blackColor );
			PaintRect( &backdropPortZRect );
			QuickFadeIn( nil );
			KeyboardSetup( );
			QuickFadeOut( nil );
			goto redo;
	}
}

void ShowGameOverScreen( void )
{
	unsigned long timer = TickCount() + (60*3);
	
	QuickFadeOut(nil);

	DrawPictInPort( backdropPort, picGameOver );

	QuickFadeIn( nil );
	do
	{
		CheckKeys( false, nil, nil );
		if( TickCount() > timer ) break;
	}
	while( !AnyKeyIsPressed( ) && !Button() );
	QuickFadeOut( nil );
}

void InitStage( void )
{
	stageWindowZRect.top = stageWindowZRect.left = 0;
	stageWindowZRect.bottom = 32; stageWindowZRect.right = 64; 
	
	stageWindowRect = stageWindowZRect;
	CenterRectInPort( &stageWindowRect, backdropPort, 0.5, 0.65 );
}

void DrawStage( void )
{
	Rect numberRect = { 0, kNumberHorizSize/8, kNumberVertSize, kNumberHorizSize*9/8 };
	OffsetRect( &numberRect, stageWindowRect.left, stageWindowRect.top );
		
	switch( players )
	{
		case 0:
		case 2:
			break;
			
		case 1:
			SetPort( backdropPort );

			CopyBits( GetPortBitMapForCopyBits(boardWorld[0]),		
					  GetPortBitMapForCopyBits(backdropPort),
		  			  &stageWindowZRect, &stageWindowRect,
		 			  srcCopy, nil );
			
			if( level < 10 )
			{
				OffsetRect( &numberRect, kNumberHorizSize*3/8, 0 );
			}
			
			DrawCharacter( kCharacterStage,   &numberRect );
			OffsetRect( &numberRect, kNumberHorizSize, 0 );
			DrawCharacter( kCharacterStage+1, &numberRect );

			if( level < 10 )
			{
				OffsetRect( &numberRect, kNumberHorizSize, 0 );
				DrawCharacter( level + '0', &numberRect );
			}
			else
			{
				OffsetRect( &numberRect, kNumberHorizSize*3/4, 0 );
				DrawCharacter( (level / 10) + '0', &numberRect );
				OffsetRect( &numberRect, kNumberHorizSize, 0 );
				DrawCharacter( (level % 10) + '0', &numberRect );
			}
			
			break;
	}
}

void InitGame( int player1, int player2 )
{
	playerWindowVisible[0] = true;
	nextWindowVisible[0] = true;
	scoreWindowVisible[0] = true;
	grayMonitorVisible[0] = true;
	
	if( player2 == kNobodyControl )
	{
		playerWindowVisible[1] = false;
		nextWindowVisible[1] = false;
		scoreWindowVisible[1] = false;
		grayMonitorVisible[1] = false;

		CenterRectInPort( &playerWindowRect[0], backdropPort, 0.5, 0.5  );
		CenterRectInPort( &scoreWindowRect[0],  backdropPort, 0.5, 0.89 );
		CenterRectInPort( &grayMonitorRect[0],  backdropPort, 0.5, 0.11 );
		CenterRectInPort( &nextWindowRect[0],   backdropPort, 0.3, 0.25 );
		
		CenterRectInPort( &stageWindowRect,		backdropPort, 0.3, 0.65 );		
		CenterRectInPort( &opponentWindowRect,  backdropPort, 0.3, 0.5 );		
	}
	else
	{
		playerWindowVisible[1] = true;
		nextWindowVisible[1] = true;
		scoreWindowVisible[1] = true;
		grayMonitorVisible[1] = true;

		CenterRectInPort( &playerWindowRect[0], backdropPort, kLeftPlayerWindowCenter, 0.5  );
		CenterRectInPort( &scoreWindowRect[0],  backdropPort, kLeftPlayerWindowCenter, 0.89 );
		CenterRectInPort( &grayMonitorRect[0],  backdropPort, kLeftPlayerWindowCenter, 0.11 );
		CenterRectInPort( &nextWindowRect[0],   backdropPort, 0.46, 0.25 );

		CenterRectInPort( &playerWindowRect[1], backdropPort, kRightPlayerWindowCenter, 0.5  );
		CenterRectInPort( &scoreWindowRect[1],  backdropPort, kRightPlayerWindowCenter, 0.89 );
		CenterRectInPort( &grayMonitorRect[1],  backdropPort, kRightPlayerWindowCenter, 0.11 );
		CenterRectInPort( &nextWindowRect[1],   backdropPort, 0.54, 0.25 );

		CenterRectInPort( &stageWindowRect,    backdropPort, 0.5, 0.65 );		
		CenterRectInPort( &opponentWindowRect, backdropPort, 0.5, 0.5 );		
	}
	
	nextWindowVisible[0] = ( player1 == kAutoControl )? false: true;
	
	players = (player1 == kPlayerControl) + (player2 == kPlayerControl);
	
	if( players < 2 )
	{
		difficulty[0] = difficulty[1] = kHardLevel;
	}
	
	control[0] = player1;
	control[1] = player2;
	
	score[0] = score[1] = displayedScore[0] = displayedScore[1] = 0;	
	roundStartScore[0] = roundStartScore[1] = 0;
	
	level = 1;
	credits = (player2 == kNobodyControl)? 1: 5;
}

Boolean InitCharacter( int player, int level )
{
	Handle res;
	
	if( !IsRegistered() )
	{
		int levelCap = kSharewareLevels;
		if( control[1] == kNobodyControl ) levelCap = kSharewareSolitaireLevels;
		
		if( level > levelCap && level != kTutorialLevel ) return false;
	}
	
	res = GetResource( kOpponentResource, level+128 );
	if( res != nil )
	{
		HLock( res );
		BlockMoveData( *res, &character[player], sizeof( Character ) );
		ReleaseResource( res );
		
		return true;
	}
	else
	{
		return false;
	}
}

void PrepareStageGraphics( int type )
{
	int player;
	                            
	Rect blobBoard = { 0, 0, kGridDown * kBlobVertSize, kGridAcross * kBlobHorizSize };
	
	backgroundID = type * 100;
	
	DrawPictInGWorld( boardWorld[0], picBoard + backgroundID );	
	DrawPictInGWorld( smallBoardWorld[0], picBoard + backgroundID );

	if( ResourceExists( 'PICT', picBoardRight + backgroundID ) )
	{
		DrawPictInGWorld( boardWorld[1], picBoardRight + backgroundID );
		DrawPictInGWorld( smallBoardWorld[1], picBoardRight + backgroundID );
	}
	else
	{
		DrawPictInGWorld( boardWorld[1], picBoard + backgroundID );
		DrawPictInGWorld( smallBoardWorld[1], picBoard + backgroundID );
	}

	DrawPictInGWorld( backdropWorld, picBackdrop + backgroundID );
	
/*	if( pirateCode )
	{
		Str255 myString;
		int width;
		
		PrepareForGDrawing( backdropWorld );

		TextFont( 3 );
		TextSize( 20 );
		TextFace( bold );

		CopyPString( myString, "\pSoftware piracy is a crime!!" );
		width = StringWidth( myString );
		MoveTo( 320 - (width/2), 460 );

		ForeColor( redColor );
		DrawShadowText( "\pSoftware piracy is a crime!!" );
		ForeColor( blackColor );
		
		FinishGDrawing( backdropWorld );
	}
*/	
	DrawPictInGWorld( nextWorld, picNext + backgroundID );
	
	for( player=0; player<=1; player++ )
	{
		PrepareForGDrawing( playerWorld[player] );
		DrawBoard( player, &blobBoard );
		FinishGDrawing( playerWorld[player] );
		
		CleanSpriteArea( player, &blobBoard );
	}
	
	BeginOpponent( type );

	RedrawBoardContents( 0 );
	RedrawBoardContents( 1 );
	
	RefreshAll( );

	backdropTicks = TickCount( );
	backdropFrame = 0;
}

void BeginRound( Boolean changeMusic )
{
	int player, count, count2;
	
	InitGrays( );
	InitPotentialCombos( );
	
	switch( players )
	{
		case 0:
		case 1:
			if( InitCharacter( 1, level ) )
			{
				score[1] = roundStartScore[1] = displayedScore[1] = 0;
				character[0] = character[1];
				character[0].zapStyle = RandomBefore(5);
			}
			else
			{
				TotalVictory( );
				return;
			}
			
			if( control[1] == kNobodyControl )
			{
				InitRandom( 3 );
			}
			else
			{
				InitRandom( 5 );
			}
			break;
			
		case 2:
			score[0] = score[1] = roundStartScore[0] = roundStartScore[1] = displayedScore[0] = displayedScore[1] = 0;	

			InitRandom( 5 );

			SelectRandomLevel( );
			InitCharacter( 0, level );
			
			SelectRandomLevel( );
			InitCharacter( 1, level );
			
			character[0].hints = (difficulty[0] == kEasyLevel) || (difficulty[0] == kMediumLevel);
			character[1].hints = (difficulty[1] == kEasyLevel) || (difficulty[1] == kMediumLevel);
			break;
	}
	
	for( player=0; player<=1; player++ )
	{
		for( count=0; count<kGridAcross; count++ )
		{
			grays[player][count] = 0;
			
			for( count2=0; count2<kGridDown; count2++ )
			{
				grid[player][count][count2] = kEmpty;
				suction[player][count][count2] = kNoSuction;
				charred[player][count][count2] = kNoCharring;
				glow[player][count][count2] = false;
			}
		}
		
		nextA[player] = GetPiece( player );
		nextB[player] = GetPiece( player );
		nextM[player] = false;
		nextG[player] = false;
		
		halfway[player] = false;
		
		unallocatedGrays[player] = 0;
		anim[player] = 0;
		lockGrays[player] = 0;
		roundStartScore[player] = score[player];
		
		RedrawBoardContents(player);
		
		if( control[player] != kNobodyControl )
		{
			role[player] = kWaitForRetrieval;
		}
		else
		{
			role[player] = kIdlePlayer;
		}
	}
	
	PrepareStageGraphics( character[1].picture );
	if( changeMusic ) ChooseMusic( character[1].music );
	
	blobTime[0]     = blobTime[1]     = 
	boredTime[0]    = boredTime[1]    = 
	hintTime[0]     = hintTime[1]     =
	timeAI[0]       = timeAI[1]       =
	fadeCharTime[0] = fadeCharTime[1] = 
	messageTime     = startTime       =
	blinkTime[0]    = blinkTime[1]    = GameTickCount( );
	
	blinkTime[1] += 60;
	
	if( players == 2 )
		InitDifficulty( );
}

void IncrementLevel( void )
{
	level++;
}

void SelectRandomLevel( void )
{
	level = RandomBefore( IsRegistered()? kLevels: kSharewareLevels ) + 1;
}

void InitDifficulty( )
{
	Rect blobBoard = { 0, 0, kGridDown * kBlobVertSize, kGridAcross * kBlobHorizSize };
	int player;
	const int selectionRow = 5;
	int count;
	Rect blobRect;
	
	for( player=0; player<=1; player++ )
	{
		// Set up variables
		role[player] = kChooseDifficulty;
		colorA[player] = RandomBefore(kBlobTypes)+1;
		colorB[player] = kEmpty;
		switch( difficulty[player] )
		{
			case kEasyLevel:      blobX[player] = 1; break;
			case kMediumLevel:    blobX[player] = 2; break;
			case kHardLevel:      blobX[player] = 3; break;
			case kUltraLevel:     blobX[player] = 4; break;
		}
		
		blobY[player] = selectionRow;
		blobR[player] = upRotate;
		blobTime[player] = GameTickCount( ) + (60*8);
		animTime[player] = GameTickCount( );
		shadowDepth[player] = kBlobShadowDepth;
		magic[player] = false;
		grenade[player] = false;
		
		// Draw fun pictures in the board
		DrawPictInGWorld( boardWorld[player], picSelectDifficulty + backgroundID );

		PrepareForGDrawing( playerWorld[player] );
		DrawBoard( player, &blobBoard );
		
		grid[player][0][selectionRow] = kGray;
		suction[player][0][selectionRow] = kEasyGray;
		charred[player][0][selectionRow] = kNoCharring;
		CalcBlobRect( 0, selectionRow, &blobRect );
		DrawBlob( player, &blobRect, kGray, kEasyGray, kNoCharring );
		
		grid[player][kGridAcross-1][selectionRow] = kGray;	
		suction[player][kGridAcross-1][selectionRow] = kHardGray;
		charred[player][kGridAcross-1][selectionRow] = kNoCharring;
		CalcBlobRect( kGridAcross-1, selectionRow, &blobRect );
		DrawBlob( player, &blobRect, kGray, kHardGray, kNoCharring );

		CalcBlobRect( 1, selectionRow, &blobRect );
		blobRect.top -= 4; blobRect.bottom += 4;
		blobRect.left += 4; blobRect.right -= 4;
		for( count=1; count<=4; count++ )
		{
			DrawCharacter( count + '0', &blobRect );
			OffsetRect( &blobRect, kBlobHorizSize, 0 );
		}
		
		FinishGDrawing( playerWorld[player] );
		
		DrawSpriteBlobs( player, kNoSuction );
		CleanSpriteArea( player, &blobBoard );
	}
}

void ChooseDifficulty( int player )
{
	Rect blobBoard = { 0, 0, kGridDown * kBlobVertSize, kGridAcross * kBlobHorizSize };
	const int selectionRow = 5;
	const int difficultyMap[kGridAcross] = {kEasyLevel, kEasyLevel, kMediumLevel, kHardLevel, kUltraLevel, kUltraLevel};
	const int fallingSpeed[kGridAcross] = {0, 15, 9, 7, 4, 0};
	const int startGrays[kGridAcross] = {0, 0,  0, 10, 20, 0};
	const int difficultyFrame[] = { kNoSuction, blobBlinkAnimation, blobBlinkAnimation,
									  blobJiggleAnimation, blobCryAnimation, kNoSuction };
	int oldX = blobX[player];
	
	if( !IsRegistered( ) )
	{
		if( player == 0 )
		{
			HandleDialog( kRegisterDialog );
			QuickFadeOut( nil );
			showStartMenu = true;
		}	

		return;	
	}
	
	PlayerControl( player );
	if( blobX[player] != oldX ) anim[player] = 0;
	
	UpdateTweak( player, difficultyFrame[blobX[player]] );

	if( GameTickCount( ) >= blobTime[player] )
	{
		if( player == 1 && ResourceExists( 'PICT', picBoardRight + backgroundID ) )
		{
			DrawPictInGWorld( boardWorld[player], picBoardRight + backgroundID );
		}
		else
		{
			DrawPictInGWorld( boardWorld[player], picBoard + backgroundID );
		}
		
		PrepareForGDrawing( playerWorld[player] );
		DrawBoard( player, &blobBoard );
		FinishGDrawing( playerWorld[player] );
		
		CleanSpriteArea( player, &blobBoard );
	
		grid[player][0][selectionRow] = kEmpty;
		grid[player][5][selectionRow] = kEmpty;
												
		suction[player][0][selectionRow] = kNoSuction;
		suction[player][5][selectionRow] = kNoSuction;
		
		difficulty[player]          = difficultyMap[ blobX[player] ];
		character[player].dropSpeed = fallingSpeed[ blobX[player] ];
		unallocatedGrays[player] = lockGrays[player] = startGrays[blobX[player]];
		character[player].hints     = (startGrays[blobX[player]] == 0);
		role[player] = kWaitingToStart;
		
		PlayStereoFrequency( player, kPause, player );
	}
}

char *gameCredits[][6] = 
{
	{ "Programming", "John Stiles", "", "", "", "" },
	{ "Artwork", "Kate Davis", "Leanne Stiles", "Arnauld de la Grandiere", "Bob Frasure", "Ryan Bliss" },
	{ "Music", "Leanne Stiles", "LibMikMod", "Lizardking", "Armadon, Explizit", "Leviathan, Nemesis" },
	{ "Music", "Jester, Pygmy", "Siren", "Sirrus", "Scaven, FC", "Spring" }, 		  
	{ "Music", "Timewalker", "Jason, Silents", "Chromatic Dragon", "Ng Pei Sin", "" }, 		  
	{ "Special Thanks", "All Skittles fans", "My beta testing crew", "GameSprockets team", "modarchive.com", "digitalblasphemy.com" },	  
	{ "Please Register!", "The full version of", "Candy Crisis features", "twelve stages and", "also includes two", "player mode." } 		  
};


void SharewareVictory( void )
{
	SkittlesFontPtr textFont, titleFont;
	GWorldPtr backBuffer, frontBuffer;
	Rect creditSrcRect = { 0, 0, 369, 150 };
	Rect bufferSrcRect = { 0, 50, 480, 300 };
	Rect bufferDstRect = { 0, 0, 480, 250 };
	int scroll, ticks, delay = 2, x, y;
	Point dPoint = { 450, 50 }, lPoint, cPoint;
	char *text;
	int thisFade;
	char fade[240] = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, //0
				               1, 2, 3, 4, 5, 6, 7, 8, 9,10, //1
				              11,12,13,14,15,16,17,18,19,20, //2
				              20,20,20,20,20,20,20,20,20,20, //3
				              20,20,20,20,20,20,20,20,20,20, //3
				              20,20,20,20,20,20,20,20,20,20, //3
				              20,20,20,20,20,20,20,20,20,20, //3
				              20,20,20,20,20,20,20,20,20,20, //3
				              20,20,20,20,20,20,20,20,20,20, //3
							  20,19,18,17,16,15,14,13,12,11, //9
							  10, 9, 8, 7, 6, 5, 4, 3, 2, 1, //10
							   0, 0, 0, 0, 0, 0, 0, 0, 0, 0  //11
						   };
	              
	titleFont = GetFont( picFont );
	textFont = GetFont( picTinyFont );
			
	DrawPictInPort( backdropPort, picSharewareVictory );
	
	InitGWorld( &backBuffer, &bufferDstRect, 16 );
	CopyBits( GetPortBitMapForCopyBits(backdropPort), GetPortBitMapForCopyBits(backBuffer),
			  &bufferSrcRect, &bufferDstRect, srcCopy, nil );

	InitGWorld( &frontBuffer, &bufferDstRect, 16 );
	
	QuickFadeIn( nil );	

	ChooseMusic( 12 ); 
	
	ticks = TickCount();
	for( scroll=0; scroll<1500; scroll++ )
	{
		PrepareForGDrawing( frontBuffer );		  
		CopyBits( GetPortBitMapForCopyBits(backBuffer), GetPortBitMapForCopyBits(frontBuffer),
				  &bufferDstRect, &bufferDstRect, srcCopy, nil );
		
		ticks += 3;
		lPoint = dPoint;
		for( y=0; y<7; y++ )
		{
			if( y != 3 && y != 4 )
			{
				cPoint.v = lPoint.v + 25;
				cPoint.h = lPoint.h;
				if( cPoint.v > 480 ) break;
				
				if( cPoint.v > 0 )
				{
					text = gameCredits[y][0];
					thisFade = fade[cPoint.v >> 2];
					
					while( *text )
					{
						BlitWeightedCharacter( titleFont, *text++, &cPoint, 31, 31, 0, thisFade );
					}
				}
				
				lPoint.v += 50;
			}
			
			for( x=1; x<6; x++ )
			{
				if( gameCredits[y][x][0] )
				{
					cPoint.v = lPoint.v;
					cPoint.h = lPoint.h + 20;
					if( cPoint.v > 480 ) break;

					if( cPoint.v > 0 )
					{
						text = gameCredits[y][x];
						thisFade = fade[cPoint.v >> 2];
						
						while( *text )
						{
							BlitWeightedCharacter( textFont, *text++, &cPoint, 31, 31, 0, thisFade );
						}
					}

					lPoint.v += 20;
				}
			}
		}
		
		FinishGDrawing( frontBuffer );
		dPoint.v--;

		SetPort( backdropPort );
		CopyBits( GetPortBitMapForCopyBits(frontBuffer), GetPortBitMapForCopyBits(backdropPort), 
			  &bufferDstRect, &bufferSrcRect, srcCopy, nil );
		
		do
		{ 
			MPYield();
			if( Button( ) ) goto out;	
		}
		while( ticks >= TickCount() );
	}
	
	do
	{
		CheckKeys( false, nil, nil );
	}
	while( !AnyKeyIsPressed( ) && !Button() );

out:
	QuickFadeOut( nil );	
	
	DisposeGWorld( backBuffer );
	DisposeGWorld( frontBuffer );
	DisposeFont( titleFont );
	DisposeFont( textFont );
}

void RegisteredVictory( void )
{
	SkittlesFontPtr textFont, titleFont, bubbleFont;
	Rect backBufferRect = {0, 0, 730, 640}, frontBufferRect = {0, 0, 480, 640},
	     highRect = {0, 0, 480, 640}, lowRect = {250, 0, 730, 640}, scrollRect;
	GWorldPtr backBuffer, frontBuffer;
	Point dPoint[] = { { 230, 340 }, { 230, 30 }, { 230, 30 }, { 30, 30 }, { 30, 340 }, { 230, 340 } }; 
	Point bubblePoint, textPoint, shadowPoint;
	Point setPoint[6][6];
	Point msgSetPoint[6][2];
	long ticks;
	int vertScroll, picture, weight, line, minimum;
	int scrollDir[] = {1, -1, 1, -1, 1, -1};
	int spacing[] = {40, 19, 19, 19, 23, 19};
	char *text;
	Rect backdropPortRect;
	
	char *messages[6][2] =
	{
		{ "Congratulations!", "" },
		{ "You've managed to vaporize all", "of the rampaging candies!" },
		{ "Your quick thinking and sharp", "reflexes have saved the day." },
		{ "", "" },
		{ "", "" },
		{ "Thanks for playing Candy Crisis!", "" },
	};
	
	textFont = GetFont( picFont );
	titleFont = GetFont( picHiScoreFont );
	bubbleFont = GetFont( picBubbleFont );
	
	ChooseMusic( 14 ); 

	for( picture=0; picture<6; picture++ )
	{
		for( line=0; line<2; line++ )
		{
			msgSetPoint[picture][line].v = ((dPoint[picture].v == 230)? 100: 400) + (line * 30);
			msgSetPoint[picture][line].h = 640;
			
			text = messages[picture][line];
			while( *text )
			{
				msgSetPoint[picture][line].h -= titleFont->width[*text++];
			}

			msgSetPoint[picture][line].h /= 2;			
		}
		
		for( line=0; line<6; line++ )
		{
			SkittlesFontPtr font;

			if( line == 0 )
			{
				font = titleFont;
				textPoint.v = 45;				
			}
			else
			{
				font = textFont;
				textPoint.v = 65 + (spacing[picture] * line);				
			}

			textPoint.h = bubbleFont->width['*'];

			text = gameCredits[picture][line];
			while( *text )
			{
				textPoint.h -= font->width[*text++];
			}
			
			setPoint[picture][line].v = dPoint[picture].v + textPoint.v;
			setPoint[picture][line].h = dPoint[picture].h + textPoint.h / 2;
		}
		
		minimum = 640;
		for( line=1; line<6; line++ )
		{
			if( setPoint[picture][line].h < minimum ) minimum = setPoint[picture][line].h;
		}
		
		for( line=1; line<6; line++ )
		{
			setPoint[picture][line].h = minimum;
		}		
	}
	
	InitGWorld( &backBuffer,  &backBufferRect,  16 );
	InitGWorld( &frontBuffer, &frontBufferRect, 16 );
	
	for( picture = 0; picture<6; picture++ )
	{
		scrollRect = ( scrollDir[picture] > 0 )? highRect: lowRect;
		
		DrawPictInGWorld( backBuffer, picture + picVictory1 );

		SetPort( backdropPort );
		GetPortBounds( backdropPort, &backdropPortRect );
		CopyBits( GetPortBitMapForCopyBits(backBuffer), 
				  GetPortBitMapForCopyBits(backdropPort),
		          &scrollRect, &backdropPortRect, srcCopy, nil );
		
		QuickFadeIn( nil );
		
		ticks = TickCount();
		for( vertScroll = 0; vertScroll < 250; vertScroll++ )
		{
			PrepareForGDrawing( frontBuffer );
			CopyBits( GetPortBitMapForCopyBits(backBuffer), 
					  GetPortBitMapForCopyBits(frontBuffer),
			          &scrollRect, &frontBufferRect,
			          srcCopy, nil );
			
			weight = vertScroll - 20;
			for( line=0; line<2; line++ )
			{
				textPoint = msgSetPoint[picture][line];
				shadowPoint.v = textPoint.v + 1;
				shadowPoint.h = textPoint.h + 1;
				
				text = messages[picture][line];
				
				while( *text && weight > 0 )
				{
					int fixedWeight = (weight > 31)? 31: weight;
					
					BlitWeightedCharacter( titleFont, *text, &shadowPoint, 0,  0,  0, fixedWeight );
					BlitWeightedCharacter( titleFont, *text, &textPoint,   31, 31, 31, fixedWeight );
					weight--;
					text++;
				}
			}
			
			bubblePoint = dPoint[picture];
			weight = ( vertScroll <= 210 )? vertScroll - 10: 241 - vertScroll;
			if( weight < 0  ) weight = 0;
			if( weight > 31 ) weight = 31;
			
			if( weight > 0 )
			{
				BlitWeightedCharacter( bubbleFont, '*', &bubblePoint, 31, 31, 31, (weight+1)>>1 );
				
				for( line=0; line<6; line++ )
				{
					SkittlesFontPtr font = (line == 0)? titleFont: textFont;
					
					textPoint = setPoint[picture][line];
					text = gameCredits[picture][line];
					
					while( *text )
					{
						BlitWeightedCharacter( font, *text++, &textPoint, 0, 0, 0, weight );
					}
				}
			}
			
			FinishGDrawing( frontBuffer );
			
			SetPort( backdropPort );
			CopyBits( GetPortBitMapForCopyBits(frontBuffer), 
			          GetPortBitMapForCopyBits(backdropPort),
			          &frontBufferRect, &backdropPortRect,
			          srcCopy, nil );

			OffsetRect( &scrollRect, 0, scrollDir[picture] );
			
			ticks += 4;
			do
			{ 
				MPYield();
				if( Button( ) ) vertScroll = 250;
			}			
			while( ticks >= TickCount() );
		}

		QuickFadeOut( nil );
	}
	
	DisposeGWorld( backBuffer  );
	DisposeGWorld( frontBuffer );
	DisposeFont( bubbleFont );
	DisposeFont( titleFont );
	DisposeFont( textFont );
}

void TotalVictory( void )
{
	AddHiscore( score[0] );
	QuickFadeOut( nil );	

	SetPort( backdropPort );

	if( !IsRegistered() )
	{
		SharewareVictory( );
	}
	else
	{
		RegisteredVictory( );
	}

	showStartMenu = true;
}